def _cmake_to_bool(s):
    return s.upper() not in ['', '0','FALSE','OFF','N','NO','IGNORE','NOTFOUND']

is_python_package    = _cmake_to_bool("")

BUILD_STUB_FILES     = _cmake_to_bool("ON")
BUILD_UMFPACK        = _cmake_to_bool("")
ENABLE_UNIT_TESTS    = _cmake_to_bool("OFF")
INSTALL_DEPENDENCIES = _cmake_to_bool("OFF")
USE_CCACHE           = _cmake_to_bool("ON")
USE_HYPRE            = _cmake_to_bool("OFF")
USE_LAPACK           = _cmake_to_bool("ON")
USE_MKL              = _cmake_to_bool("OFF")
USE_MUMPS            = _cmake_to_bool("OFF")
USE_PARDISO          = _cmake_to_bool("OFF")
USE_UMFPACK          = _cmake_to_bool("OFF")

NETGEN_DIR = "/opt/netgen"

NGSOLVE_COMPILE_DEFINITIONS         = "HAVE_NETGEN_SOURCES;HAVE_DLFCN_H;HAVE_CXA_DEMANGLE;USE_TIMEOFDAY;LAPACK;NGS_PYTHON"
NGSOLVE_COMPILE_DEFINITIONS_PRIVATE = ""
NGSOLVE_COMPILE_INCLUDE_DIRS        = ""
NGSOLVE_COMPILE_OPTIONS             = "$<$<COMPILE_LANGUAGE:CXX>:-Wno-undefined-var-template;-Wno-vla-extension>;-DMAX_SYS_DIM=1"

NGSOLVE_INSTALL_DIR_PYTHON   = "python"
NGSOLVE_INSTALL_DIR_BIN      = "bin"
NGSOLVE_INSTALL_DIR_LIB      = "python"
NGSOLVE_INSTALL_DIR_INCLUDE  = "include"
NGSOLVE_INSTALL_DIR_CMAKE    = "lib/cmake/ngsolve"
NGSOLVE_INSTALL_DIR_RES      = "share"

NGSOLVE_VERSION = "6.2.2601-98-g429b78aeb"
NGSOLVE_VERSION_GIT = "v6.2.2601-98-g429b78aeb"
NGSOLVE_VERSION_PYTHON = ""

NGSOLVE_VERSION_MAJOR = "6"
NGSOLVE_VERSION_MINOR = "2"
NGSOLVE_VERSION_TWEAK = "98"
NGSOLVE_VERSION_PATCH = "2601"
NGSOLVE_VERSION_HASH = "g429b78aeb"

CMAKE_CXX_COMPILER           = "/root/emsdk/upstream/emscripten/em++"
CMAKE_CUDA_COMPILER          = ""
CMAKE_C_COMPILER             = "/root/emsdk/upstream/emscripten/emcc"
CMAKE_LINKER                 = "/usr/bin/ld"
CMAKE_INSTALL_PREFIX         = "/opt/netgen"
CMAKE_CXX_COMPILER_LAUNCHER  = "/usr/bin/ccache"

version = NGSOLVE_VERSION_GIT

MKL_LINK = ""

def get_cmake_dir():
    import os.path as p
    d_python = p.dirname(p.dirname(p.dirname(__file__)))
    py_to_cmake = p.relpath(
            NGSOLVE_INSTALL_DIR_CMAKE,
            NGSOLVE_INSTALL_DIR_PYTHON
            )
    return p.normpath(p.join(d_python,py_to_cmake))
